/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

class SAShowDialogs {
    SAShowDialogs() {
    }

    public void showWarning() {
        JOptionPane.showMessageDialog(null, "The first dialog will be an open dialog, you can only open JPEGs, GIFs, and PNGs currently.\nIf you want it to make a rotated spin from one image, only choose one image.\n\nIf it is a single image, it will ask for the total amount of frames to be created, only numbers divisible by 6 allowed.\n\nIf the picture or pictures have an alpha channel, it will ask whether you want to extract them as a mask.\n\nThe second dialog will be a save dialog, it will auto save as a PICT,\nbut it doesn't add the extension, so add .pict to the end.\n\nIf you decided to extract a mask, it will pop up another dialog asking where to save it.");
        this.showOpen();
    }

    public void showOpen() {
        int num;
        BufferedImage[] loadimages = null;
        RenderedImage finalimage = null;
        RenderedImage finalmask = null;
        SADoStuff doStuff = new SADoStuff();
        JFileChooser chooser = new JFileChooser();
        boolean exmask = false;
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle("Open JPEG, GIF, or PNG Image/s");
        if (chooser.showOpenDialog(null) != 0) {
            return;
        }
        File[] loadfiles = chooser.getSelectedFiles();
        for (num = 0; num < loadfiles.length; ++num) {
            String filename = loadfiles[num].getName();
            String extension = "";
            boolean atit = false;
            for (int where = 0; filename.length() > where; ++where) {
                if (filename.charAt(where) == '.') {
                    atit = true;
                    continue;
                }
                if (!atit) continue;
                extension = extension + filename.charAt(where);
            }
            if (extension.equals("jpg") || extension.equals("png") || extension.equals("gif") || extension.equals("jpeg")) continue;
            JOptionPane.showMessageDialog(null, "Error!!!\nYou must select either a JPEG, PNG, or a GIF Image.");
            this.showOpen();
            return;
        }
        loadimages = new BufferedImage[loadfiles.length];
        for (num = 0; num < loadfiles.length; ++num) {
            loadimages[num] = doStuff.load(loadfiles[num]);
        }
        if (loadimages.length > 1) {
            if (loadimages[0].getAlphaRaster() != null && 0 == JOptionPane.showConfirmDialog(null, "Do you wish to extract mask from alpha channel?")) {
                exmask = true;
                finalmask = doStuff.createSpinMulti(doStuff.extractMaskMulti(loadimages));
            }
            finalimage = doStuff.createSpinMulti(loadimages);
        } else if (loadimages.length == 1) {
            int total = 36;
            total = Integer.parseInt(JOptionPane.showInputDialog(null, "Please enter the number of frames to create", new Integer(36)));
            if (loadimages[0].getAlphaRaster() != null && 0 == JOptionPane.showConfirmDialog(null, "Do you wish to extract mask from alpha channel?")) {
                exmask = true;
                finalmask = doStuff.createSpinSingle(doStuff.extractMaskSingle(loadimages[0]), total);
            }
            finalimage = doStuff.createSpinSingle(loadimages[0], total);
        }
        this.showSave(finalimage, "Spin");
        if (exmask) {
            this.showSave(finalmask, "Mask");
        }
    }

    public void showSave(RenderedImage finalimage, String name) {
        JFileChooser chooser = new JFileChooser();
        SADoStuff doStuff = new SADoStuff();
        chooser = new JFileChooser();
        chooser.setSelectedFile(new File(name + ".pict"));
        chooser.setDialogTitle("Save PICT Image");
        if (chooser.showSaveDialog(null) == 0) {
            doStuff.save(chooser.getSelectedFile(), finalimage);
        }
    }
}

