/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

class SADoStuff {
    SADoStuff() {
    }

    public void save(File savefile, RenderedImage finalimage) {
        PICTImageSaver is = new PICTImageSaver();
        is.setSaveImage((Image)((Object)finalimage));
        is.setSavePath(savefile.getPath());
        is.saveIt();
    }

    public BufferedImage load(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public BufferedImage extractMaskSingle(BufferedImage loadimage) {
        BufferedImage mask = new BufferedImage(loadimage.getWidth(), loadimage.getHeight(), 10);
        mask.setData(loadimage.getAlphaRaster());
        return mask;
    }

    public BufferedImage[] extractMaskMulti(BufferedImage[] loadimages) {
        BufferedImage[] masks = new BufferedImage[loadimages.length];
        for (int num = 0; num < loadimages.length; ++num) {
            masks[num].setData(loadimages[num].getAlphaRaster());
        }
        return masks;
    }

    public RenderedImage createSpinSingle(BufferedImage loadimage, int total) {
        BufferedImage bufferedImage = new BufferedImage(loadimage.getWidth() * 6, loadimage.getHeight() * (total / 6), 1);
        BufferedImage bufferedImage2 = new BufferedImage(loadimage.getWidth(), loadimage.getHeight(), 1);
        if (loadimage.getAlphaRaster() != null) {
            int[] test = new int[loadimage.getWidth() * loadimage.getHeight()];
            for (int num = 0; num < loadimage.getWidth() * loadimage.getHeight(); ++num) {
                test[num] = 255;
            }
            loadimage.getAlphaRaster().setPixels(0, 0, loadimage.getWidth(), loadimage.getHeight(), test);
        }
        Graphics2D g = bufferedImage.createGraphics();
        Graphics2D g2 = bufferedImage2.createGraphics();
        for (int num = 0; num < total / 6; ++num) {
            for (int num2 = 0; num2 < 6; ++num2) {
                g2.drawImage((Image)loadimage, 0, 0, null);
                g2.rotate(Math.toRadians(360.0 / (double)total), (double)loadimage.getWidth() / 2.0, (double)loadimage.getHeight() / 2.0);
                g.drawImage((Image)bufferedImage2, num2 * loadimage.getWidth(), num * loadimage.getHeight(), null);
            }
        }
        g.dispose();
        return bufferedImage;
    }

    public RenderedImage createSpinMulti(BufferedImage[] loadimages) {
        int maxwidth = 0;
        int maxheight = 0;
        for (maxwidth = (int)Math.sqrt(loadimages.length); maxwidth <= loadimages.length && loadimages.length % maxwidth != 0; ++maxwidth) {
        }
        maxheight = loadimages.length / maxwidth;
        BufferedImage bufferedImage = new BufferedImage(loadimages[0].getWidth() * maxwidth, loadimages[0].getHeight() * maxheight, 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.setBackground(Color.orange);
        for (int num = 0; num < maxheight; ++num) {
            for (int num2 = 0; num2 < maxwidth; ++num2) {
                g.drawImage((Image)loadimages[num * maxwidth + num2], num2 * loadimages[0].getWidth(), num * loadimages[0].getHeight(), null);
            }
        }
        g.dispose();
        return bufferedImage;
    }
}

