/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;

public class PICTImageSaver
extends ImageSaverInterface
implements Serializable,
ImageConsumer {
    public static final String FORMAT_CODE = "PICT";
    public static final String FORMAT_COMPLETE_NAME = "Macintosh PICT";
    public static final String FORMAT_EXTENSION = "pct";
    private final int SRC_COPY = 0;
    private final int PICT_NULL_HEADER_SIZE = 512;
    private final int IMAGE_RESOLUTION = 72;
    private final int NBR_BYTES_IN_WORD = 2;
    private final int NBR_BYTES_IN_LONG = 4;
    private final int OP_CLIP_RGN = 1;
    private final int OP_VERSION = 17;
    private final int OP_DEF_HILITE = 30;
    private final int OP_V2_HEADER_OP = 3072;
    private final int OP_DIRECT_BITS_RECT = 154;
    private final int OP_END_OF_PICTURE = 255;
    private final int OP_VERSION_2 = 767;
    private final int EXT_VERSION_2_CODE = 65534;
    private FileOutputStream writeFileHandle;
    private int width;
    private int height;
    private int rowBytes;
    private int saveStatus;
    private int byteCount;
    private byte[] scanlineBytes;
    private byte[] packedScanlineBytes;
    private int scanWidthLeft;

    public String getFormatCode() {
        return FORMAT_CODE;
    }

    public String getFormatString() {
        return FORMAT_COMPLETE_NAME;
    }

    public String getFormatExtension() {
        return FORMAT_EXTENSION;
    }

    public boolean saveIt() {
        if (this.saveImage == null) {
            return false;
        }
        this.saveStatus = 0;
        try {
            this.writeFileHandle = new FileOutputStream(this.savePath);
        }
        catch (IOException e) {
            System.out.println("IOException occurred opening FileOutputStream : " + e);
        }
        if (this.writeFileHandle == null) {
            return false;
        }
        ImageProducer ip = this.saveImage.getSource();
        if (ip == null) {
            return false;
        }
        ip.startProduction(this);
        return true;
    }

    public int checkSave() {
        return this.saveStatus;
    }

    public void setProperties(Hashtable props) {
        this.saveStatus |= 4;
    }

    public void setHints(int hintflags) {
    }

    public void setColorModel(ColorModel model) {
    }

    public void setDimensions(int w, int h) {
        byte[] byte_buf = new byte[1];
        byte[] word_buf = new byte[2];
        byte[] rect_buf = new byte[8];
        byte[] long_buf = new byte[4];
        this.width = w;
        this.height = h;
        this.byteCount = 0;
        byte[] buf = new byte[512];
        buf[0] = 80;
        buf[1] = 73;
        buf[2] = 67;
        buf[3] = 84;
        try {
            this.writeFileHandle.write(buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += buf.length;
        for (int i = 0; i < word_buf.length; ++i) {
            word_buf[i] = 0;
        }
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(0, rect_buf, 2, 4);
        this.setIntAsBytes(0, rect_buf, 0, 2);
        this.setIntAsBytes(w, rect_buf, 6, 8);
        this.setIntAsBytes(h, rect_buf, 4, 6);
        try {
            this.writeFileHandle.write(rect_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += rect_buf.length;
        this.setIntAsBytes(17, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(767, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(3072, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(65534, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(0, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(72, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(0, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(72, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(0, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += 4 * word_buf.length;
        try {
            this.writeFileHandle.write(rect_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += rect_buf.length;
        this.setIntAsBytes(0, long_buf, 0, long_buf.length);
        try {
            this.writeFileHandle.write(long_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += long_buf.length;
        this.setIntAsBytes(30, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(1, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(10, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += 2 * word_buf.length;
        try {
            this.writeFileHandle.write(rect_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += rect_buf.length;
        this.setIntAsBytes(154, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(255, long_buf, 0, long_buf.length);
        try {
            this.writeFileHandle.write(long_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += long_buf.length;
        this.rowBytes = 4 * w;
        this.setIntAsBytes(this.rowBytes, word_buf, 0, word_buf.length);
        word_buf[0] = (byte)(word_buf[0] | 0x80);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        try {
            this.writeFileHandle.write(rect_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += rect_buf.length;
        this.setIntAsBytes(0, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(4, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(0, long_buf, 0, long_buf.length);
        try {
            this.writeFileHandle.write(long_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += long_buf.length;
        this.setIntAsBytes(72, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(0, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(72, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.setIntAsBytes(0, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += 4 * word_buf.length;
        this.setIntAsBytes(16, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(32, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(3, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(8, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.setIntAsBytes(0, long_buf, 0, long_buf.length);
        try {
            this.writeFileHandle.write(long_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += long_buf.length;
        this.setIntAsBytes(0, long_buf, 0, long_buf.length);
        try {
            this.writeFileHandle.write(long_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += long_buf.length;
        this.setIntAsBytes(0, long_buf, 0, long_buf.length);
        try {
            this.writeFileHandle.write(long_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += long_buf.length;
        try {
            this.writeFileHandle.write(rect_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        try {
            this.writeFileHandle.write(rect_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += 2 * rect_buf.length;
        this.setIntAsBytes(0, word_buf, 0, word_buf.length);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        this.byteCount += word_buf.length;
        this.scanlineBytes = new byte[3 * this.width];
        this.packedScanlineBytes = new byte[DataCompression.getPackBitsMaxDestBytes(this.scanlineBytes.length)];
        this.scanWidthLeft = this.width;
        this.saveStatus |= 3;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        byte[] byte_buf = new byte[1];
        byte[] word_buf = new byte[2];
        for (int i = 0; i < h; ++i) {
            this.scanWidthLeft -= w;
            for (int j = 0; j < w; ++j) {
                int rgb = model.getRGB(pixels[off + i * scansize + j] & 0xFF);
                this.scanlineBytes[x + j] = (byte)(rgb >> 16 & 0xFF);
                this.scanlineBytes[x + this.width + j] = (byte)(rgb >> 8 & 0xFF);
                this.scanlineBytes[x + 2 * this.width + j] = (byte)(rgb & 0xFF);
            }
            if (this.scanWidthLeft != 0) continue;
            int packed_size = DataCompression.packBits(this.scanlineBytes, this.packedScanlineBytes, this.scanlineBytes.length);
            if (this.rowBytes > 250) {
                this.setIntAsBytes(packed_size, word_buf, 0, word_buf.length);
                try {
                    this.writeFileHandle.write(word_buf);
                }
                catch (IOException e) {
                    this.saveStatus = 64;
                }
                this.byteCount += word_buf.length;
            } else {
                this.setIntAsBytes(packed_size, byte_buf, 0, byte_buf.length);
                try {
                    this.writeFileHandle.write(byte_buf);
                }
                catch (IOException e) {
                    this.saveStatus = 64;
                }
                this.byteCount += byte_buf.length;
            }
            try {
                this.writeFileHandle.write(this.packedScanlineBytes, 0, packed_size);
            }
            catch (IOException e) {
                this.saveStatus = 64;
            }
            this.byteCount += packed_size;
            this.scanWidthLeft = this.width;
        }
        this.saveStatus |= 8;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        byte[] byte_buf = new byte[1];
        byte[] word_buf = new byte[2];
        for (int i = 0; i < h; ++i) {
            this.scanWidthLeft -= w;
            for (int j = 0; j < w; ++j) {
                int rgb = model.getRGB(pixels[off + i * scansize + j]);
                this.scanlineBytes[x + j] = (byte)(rgb >> 16 & 0xFF);
                this.scanlineBytes[x + this.width + j] = (byte)(rgb >> 8 & 0xFF);
                this.scanlineBytes[x + 2 * this.width + j] = (byte)(rgb & 0xFF);
            }
            if (this.scanWidthLeft != 0) continue;
            int packed_size = DataCompression.packBits(this.scanlineBytes, this.packedScanlineBytes, this.scanlineBytes.length);
            if (this.rowBytes > 250) {
                this.setIntAsBytes(packed_size, word_buf, 0, word_buf.length);
                try {
                    this.writeFileHandle.write(word_buf);
                }
                catch (IOException e) {
                    this.saveStatus = 64;
                }
                this.byteCount += word_buf.length;
            } else {
                this.setIntAsBytes(packed_size, byte_buf, 0, byte_buf.length);
                try {
                    this.writeFileHandle.write(byte_buf);
                }
                catch (IOException e) {
                    this.saveStatus = 64;
                }
                this.byteCount += byte_buf.length;
            }
            try {
                this.writeFileHandle.write(this.packedScanlineBytes, 0, packed_size);
            }
            catch (IOException e) {
                this.saveStatus = 64;
            }
            this.byteCount += packed_size;
            this.scanWidthLeft = this.width;
        }
        this.saveStatus |= 8;
    }

    public void imageComplete(int status) {
        byte[] byte_buf = new byte[1];
        byte[] word_buf = new byte[2];
        if ((this.byteCount & 1) > 0) {
            byte_buf[0] = 0;
            try {
                this.writeFileHandle.write(byte_buf);
            }
            catch (IOException e) {
                this.saveStatus = 64;
            }
        }
        this.setIntAsBytes(255, word_buf, 0, 2);
        try {
            this.writeFileHandle.write(word_buf);
        }
        catch (IOException e) {
            this.saveStatus = 64;
        }
        if (this.writeFileHandle != null) {
            try {
                this.writeFileHandle.close();
            }
            catch (IOException e) {
                this.saveStatus = 64;
            }
        }
        this.saveStatus |= 0x20;
    }

    private void setIntAsBytes(int value, byte[] bytes, int startOff, int endOff) {
        int i = endOff - 1;
        int shift_cnt = 0;
        while (i >= startOff) {
            bytes[i] = (byte)(value >> shift_cnt & 0xFF);
            --i;
            shift_cnt += 8;
        }
    }
}

