/*
 * Decompiled with CFR 0.152.
 */
public class DataCompression {
    public static void main(String[] argv) {
        int i;
        if (argv.length < 1) {
            System.out.println("Usage: DataCompression <hex data>");
            System.exit(1);
        }
        String byte_string = argv.length == 1 ? argv[0] : argv[1];
        byte[] bytes = new byte[byte_string.length() / 2];
        for (i = 0; i < byte_string.length() / 2; ++i) {
            bytes[i] = Integer.valueOf(byte_string.substring(i * 2, i * 2 + 2), 16).byteValue();
            System.out.print(Integer.toHexString(bytes[i] & 0xFF) + " ");
        }
        System.out.println();
        System.out.println(bytes.length + " bytes.");
        if (argv.length == 1) {
            byte[] dst_bytes = new byte[DataCompression.getPackBitsMaxDestBytes(bytes.length)];
            int nbr_dst_bytes = DataCompression.packBits(bytes, dst_bytes, bytes.length);
            for (i = 0; i < nbr_dst_bytes; ++i) {
                System.out.print(Integer.toHexString(dst_bytes[i] & 0xFF) + " ");
            }
            System.out.println();
        } else {
            byte[] dst_bytes = new byte[635];
            int nbr_dst_bytes = DataCompression.unPackBits(bytes, dst_bytes, 0, bytes.length);
            for (i = 0; i < nbr_dst_bytes; ++i) {
                System.out.print(Integer.toHexString(dst_bytes[i] & 0xFF) + " ");
            }
            System.out.println();
        }
    }

    public static int getPackBitsMaxDestBytes(int nbrSrcBytes) {
        return nbrSrcBytes + (nbrSrcBytes + 126) / 127;
    }

    public static int packBits(byte[] srcBytes, byte[] dstBytes, int nbrSrcBytes) {
        int i = 0;
        int flag_byte = 0;
        int dest_ind = 1;
        int diff_count = 0;
        while (i < srcBytes.length && i < nbrSrcBytes) {
            if (i + 2 < srcBytes.length && srcBytes[i] == srcBytes[i + 1] && srcBytes[i] == srcBytes[i + 2]) {
                int ident_count;
                if (diff_count > 0) {
                    dstBytes[flag_byte] = (byte)(diff_count - 1);
                    diff_count = 0;
                    flag_byte = dest_ind;
                }
                byte pack_byte = srcBytes[i];
                i += 3;
                for (ident_count = 3; ident_count < 127 && i < srcBytes.length && i < nbrSrcBytes && srcBytes[i] == pack_byte; ++ident_count, ++i) {
                }
                dstBytes[flag_byte] = (byte)(129 - ident_count | 0x80);
                dstBytes[flag_byte + 1] = pack_byte;
                dest_ind = (flag_byte += 2) + 1;
                continue;
            }
            if (diff_count >= 127) {
                dstBytes[flag_byte] = (byte)(diff_count - 1);
                diff_count = 0;
                flag_byte = dest_ind++;
            }
            dstBytes[dest_ind] = srcBytes[i];
            ++dest_ind;
            ++diff_count;
            ++i;
        }
        if (diff_count > 0) {
            dstBytes[flag_byte] = (byte)(diff_count - 1);
            flag_byte += diff_count + 1;
        }
        return flag_byte;
    }

    public static int unPackBits(byte[] srcBytes, byte[] dstBytes, int indSrcStart, int nbrSrcBytes) {
        int src_ind = indSrcStart;
        int dest_ind = 0;
        while (src_ind < srcBytes.length && src_ind - indSrcStart < nbrSrcBytes) {
            int i;
            int byte_count;
            if ((srcBytes[src_ind] & 0x80) > 0) {
                byte_count = -((srcBytes[src_ind] & 0x7F) - 128) + 1;
                ++src_ind;
                if (dest_ind + byte_count >= dstBytes.length) {
                    return dest_ind;
                }
                byte pack_byte = srcBytes[src_ind];
                ++src_ind;
                for (i = 0; i < byte_count; ++i) {
                    dstBytes[dest_ind] = pack_byte;
                    ++dest_ind;
                }
                continue;
            }
            byte_count = srcBytes[src_ind] + 1;
            ++src_ind;
            if (dest_ind + byte_count >= dstBytes.length) {
                return dest_ind;
            }
            for (i = 0; i < byte_count; ++i) {
                dstBytes[dest_ind] = srcBytes[src_ind];
                ++src_ind;
                ++dest_ind;
            }
        }
        return dest_ind;
    }
}

